*******************************************************************************
*                          680xx Grundprogramm adda                           *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                       AD- und DA-Wandler Routinen                           *
*******************************************************************************


getad8:
 movem.l d1/a0,-(a7)            * d0.b = Kanalnummer
 lea adc0816.w,a0               * Adresse
 and #$f,d0                     * Nur Kanal 0 bis 15 erlaubt
 move #cpu, d1
 lsr #1, d1                     * CPU-Wert/2
 beq.s get0ad8                  * 0 = 68008
 lsl d1, d0                     * Kanalnummer mit CPU-Wert multiplizieren
get0ad8:
 clr.b 0(a0,d0)                 * Wandler starten
get1ad8:
 tst.b (a0)                     * Warten bis gestartet
 bpl.s get1ad8
get2ad8:
 tst.b (a0)                     * Warten bis gewandelt
 bmi.s get2ad8
 moveq #0,d0                    * Langwort gltig
 move.b cpu(a0),d0              * Wert holen
 movem.l (a7)+,d1/a0
rts

getad10:
 clr.b adc1001.w                * Starten des Wandlers
 moveq #0,d0                    * Langwort gltig
get1ad10:
 tst.b adc1001.w                * Warten bis gewandelt
 bne.s get1ad10
 move.b adc1001.w,d0            * Wert holen
 lsl #8,d0
 move.b adc1001+1*cpu.w,d0      * Wert OK
rts

setda:                          * d1.b = DA Kanal 0   d2.b = DA Kanal 1
 move.b d1,da0802.w
 move.b d2,da0802+1*cpu.w
rts

setda12:
 move d0,-(a7)                  * Retten
 move.b d0,da12.w               * Kanal 1 LSB
 lsr #8,d0
 move.b d0,da12+1*cpu.w         * Kanal 1 MSB
 move d1,d0
 move.b d0,da12+2*cpu.w         * Kanal 2 LSB
 lsr #8,d0
 move.b d0,da12+3*cpu.w         * Kanal 2 MSB
 move (a7)+,d0                  * Zurck
rts

getad12:
 move d1,d0                     * In d1 stehen Voreinstellungen
 clr.b ad12+1*cpu.w             * Offset
 and #%11111,d0                 * Nur Kanal und WAIT lassen
 move.b d0,ad12+3*cpu.w         * Einstellen
 clr.b ad12.w                   * Starten
 btst #4,d1                     * WAIT oder Status-Bit ?
 beq.s getad12b                 * ber WAIT-Leitung
getad12a:
 tst.b ad12+2*cpu.w             * Warten bis
 bmi.s getad12a                 * gewandelt
getad12b:
 move.b ad12+1*cpu.w,d0         * MSB holen
 lsl #8,d0
 move.b ad12.w,d0               * LSB holen
 btst #5,d1                     * Offset ?
 beq.s getad12c                 * Ja
 lsl #4,d0                      * Zweierkomplementdarstellung
 asr #4,d0                      * Vorzeichen beachten
getad12c:
rts
                                                                                                                                                   